--[[---------------------------------------------------------------------------
	Chocolatier Two: Numeric keypad
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local function NumberKey(n)
	if gNumberPadTarget then
		local s = GetLabel(gNumberPadTarget)
		if string.len(s) < 6 then
			SetLabel(gNumberPadTarget, s..tostring(n))
--			SetFocus(gNumberPadTarget)
			if gNumberPadCallback then gNumberPadCallback() end
		end
	end
end	

local function Backspace()
	if gNumberPadTarget then
		local s = GetLabel(gNumberPadTarget)
		local l = string.len(s)
		if l > 0 then
			SetLabel(gNumberPadTarget, string.sub(s,1,l-1))
--			SetFocus(gNumberPadTarget)
			if gNumberPadCallback then gNumberPadCallback() end
		end
	end
end

local function MaxButton()
	if gNumberPadTarget then
		local item = LItem:ByName(gNumberPadTarget)
		if item and item.recipe then
			SetLabel(gNumberPadTarget, tostring(item.inventory))
--			SetFocus(gNumberPadTarget)
			if gNumberPadCallback then gNumberPadCallback() end
		else
			local max = gSim.money - 2 * Simulator.travelCost
			if max < 0 then max = 0 end
			local max = bsgFloor(max / item.price)
			SetLabel(gNumberPadTarget, tostring(max))
--			SetFocus(gNumberPadTarget)
			if gNumberPadCallback then gNumberPadCallback() end
		end
	end
end

local function NumberButton(button)
	return function()
		local number = button.number or 0
		local label = tostring(number)

		table.insert(button, FitToChildren() )
		
		table.insert(button, SelectLayer( 0 ) )
		table.insert(button, Text
			{
				label=label, x=0,y=0,w=kMax,h=26,
				name='label',
				font=standardYellowFont,
			})

		table.insert(button, SelectLayer( 1 ) )
		table.insert(button, Text
			{
				label=label, x=0,y=8,w=kMax,h=26,
				name='label',
				font=standardWhiteFont,
			})

		table.insert(button, SelectLayer( 2 ) )
		table.insert(button, Text
			{
				label=label, x=0,y=0,w=kMax,h=26,
				name='label',
				font=standardWhiteFont,
			})

--button.sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },

		button.command = function() NumberKey(number) end
		button.graphics = { "control/reg_btn","control/reg_btn_d","control/reg_btn" }
		button.typename='Button'
		DoWindow( button )
	end
end

-------------------------------------------------------------------------------

local function InsertMaxButton(button)
	return function()
		table.insert(button, FitToChildren() )
		
		table.insert(button, SelectLayer( 0 ) )
		table.insert(button, Text
			{
				label="max", x=0,y=0,w=kMax,h=20,
				name='label',
				font=standardYellowFont,
			})

		table.insert(button, SelectLayer( 1 ) )
		table.insert(button, Text
			{
				label="max", x=0,y=9,w=kMax,h=20,
				name='label',
				font=standardWhiteFont,
			})

		table.insert(button, SelectLayer( 2 ) )
		table.insert(button, Text
			{
				label="max", x=0,y=0,w=kMax,h=20,
				name='label',
				font=standardWhiteFont,
			})

--button.sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },

		button.command = MaxButton
		button.graphics = { "control/reg_btn_max_up","control/reg_btn_max_down","control/reg_btn_max_up" }
		button.typename='Button'
		DoWindow( button )
	end
end

-------------------------------------------------------------------------------

function NumberPad(x,y,target)
	local x = x or ui.screenWidth
	local y = y or ui.screenHeight
	local w=83
	local h=137
	gNumberPadTarget = target

	return Bitmap { x=x,y=y, image="control/register",
		NumberButton { x=21,y=39, number=1 },
		NumberButton { x=21+28,y=39, number=2 },
		NumberButton { x=21+2*28,y=39, number=3 },
		NumberButton { x=21+3*28,y=39, number=4 },
		NumberButton { x=21+4*28,y=39, number=5 },

		NumberButton { x=11,y=68, number=6 },
		NumberButton { x=11+28,y=68, number=7 },
		NumberButton { x=11+2*28,y=68, number=8 },
		NumberButton { x=11+3*28,y=68, number=9 },
		NumberButton { x=11+4*28,y=68, number=0 },
		
		Button { x=11+5*28,y=68, command=Backspace,
			graphics={"control/reg_btn_del","control/reg_btn_del_d","control/reg_btn_del"} },
			
		InsertMaxButton { x=3,y=9, name="number_max" },
	}
end
